/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.zencode.impl.registry;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.native_types.CrTNativeTypeInfo;
import com.blamejared.crafttweaker.impl.native_types.NativeTypeRegistry;
import com.blamejared.crafttweaker_annotations.annotations.NativeMethod;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.blamejared.crafttweaker_annotations.annotations.TypedExpansion;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.ModList;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;

public class ZenClassRegistry {
    private final NativeTypeRegistry nativeTypeRegistry = new NativeTypeRegistry();
    private final List<Class<?>> allRegisteredClasses = new ArrayList();
    private final Set<Class<?>> blacklistedClasses = new HashSet();
    private final BiMap<String, Class<?>> zenGlobals = HashBiMap.create();
    private final BiMap<String, Class<?>> zenClasses = HashBiMap.create();
    private final Map<String, List<Class<?>>> expansionsByExpandedName = new HashMap();

    public List<Class<? extends IRecipeManager>> getRecipeManagers() {
        return this.getImplementationsOf(IRecipeManager.class);
    }

    public boolean isRegistered(Class<?> cls) {
        return this.zenClasses.inverse().containsKey(cls);
    }

    public String getNameFor(Class<?> cls) {
        return (String)this.zenClasses.inverse().get(cls);
    }

    public Optional<String> tryGetNameFor(Class<?> cls) {
        if (this.isRegistered(cls)) {
            return Optional.ofNullable(this.getNameFor(cls));
        }
        return Optional.empty();
    }

    public <T> List<Class<? extends T>> getImplementationsOf(Class<T> checkFor) {
        return this.allRegisteredClasses.stream().filter(checkFor::isAssignableFrom).filter(cls -> !cls.isInterface() && !Modifier.isAbstract(cls.getModifiers())).map(cls -> cls).collect(Collectors.toList());
    }

    public List<Class<?>> getAllRegisteredClasses() {
        return this.allRegisteredClasses;
    }

    public BiMap<String, Class<?>> getZenGlobals() {
        return this.zenGlobals;
    }

    public BiMap<String, Class<?>> getZenClasses() {
        return this.zenClasses;
    }

    public Map<String, List<Class<?>>> getExpansionsByExpandedName() {
        return this.expansionsByExpandedName;
    }

    public void addClass(Class<?> cls) {
        if (this.areModsMissing(cls.getAnnotation(ZenRegister.class))) {
            String canonicalName = cls.getCanonicalName();
            CraftTweakerAPI.logDebug("Skipping class '%s' since its Mod dependencies are not fulfilled", canonicalName);
            return;
        }
        if (this.isIncompatible(cls)) {
            this.blacklistedClasses.add(cls);
            return;
        }
        this.allRegisteredClasses.add(cls);
        if (cls.isAnnotationPresent(ZenCodeType.Name.class)) {
            this.addZenClass(cls);
        }
        if (cls.isAnnotationPresent(ZenCodeType.Expansion.class)) {
            String expandedClassName = cls.getAnnotation(ZenCodeType.Expansion.class).value();
            this.addExpansion(cls, expandedClassName);
        }
        if (cls.isAnnotationPresent(TypedExpansion.class)) {
            this.addTypedExpansion(cls);
        }
        if (this.hasGlobals(cls)) {
            if (cls.isAnnotationPresent(ZenCodeType.Name.class)) {
                this.addGlobal(cls);
            } else {
                CraftTweakerAPI.logWarning("Class: '%s' has a Global value, but is missing the '%s' annotation! Please report this to the mod author!", cls, ZenCodeType.Name.class.getName());
            }
        }
    }

    private boolean isIncompatible(Class<?> cls) {
        try {
            cls.getDeclaredFields();
            cls.getFields();
            cls.getDeclaredMethods();
            cls.getMethods();
            cls.getConstructors();
            cls.getDeclaredConstructors();
            return false;
        }
        catch (Throwable t) {
            CraftTweakerAPI.logThrowing("Could not register class '%s'! This is most likely a compatibility issue!", t, cls.getCanonicalName());
            return true;
        }
    }

    private void addTypedExpansion(Class<?> cls) {
        TypedExpansion annotation = cls.getAnnotation(TypedExpansion.class);
        Class<?> expandedType = annotation.value();
        if (this.nativeTypeRegistry.hasInfoFor(expandedType)) {
            String expandedClassName = this.nativeTypeRegistry.getCrTNameFor(expandedType);
            this.addExpansion(cls, expandedClassName);
        } else if (expandedType.isAnnotationPresent(ZenCodeType.Name.class)) {
            ZenCodeType.Name nameAnnotation = expandedType.getAnnotation(ZenCodeType.Name.class);
            String expandedClassName = nameAnnotation.value();
            this.addExpansion(cls, expandedClassName);
        } else {
            String expandedTypeClassName = expandedType.getCanonicalName();
            CraftTweakerAPI.logError("Cannot add Expansion for '%s' as the expanded type is not registered!", expandedTypeClassName);
        }
    }

    private void addNativeAnnotation(Class<?> cls) {
        NativeTypeRegistration annotation = cls.getAnnotation(NativeTypeRegistration.class);
        String zenCodeName = annotation.zenCodeName();
        this.nativeTypeRegistry.addNativeType(annotation, (NativeMethod[])cls.getAnnotationsByType(NativeMethod.class));
        this.addExpansion(cls, zenCodeName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean areModsMissing(ZenRegister register) {
        if (register == null) return true;
        if (Arrays.stream(register.modDeps()).filter(modId -> modId != null && !modId.isEmpty()).allMatch(arg_0 -> ((ModList)ModList.get()).isLoaded(arg_0))) return false;
        return true;
    }

    private void addZenClass(Class<?> cls) {
        ZenCodeType.Name annotation = cls.getAnnotation(ZenCodeType.Name.class);
        String name = annotation.value();
        if (this.zenClasses.containsKey((Object)name)) {
            Class otherCls = (Class)this.zenClasses.get((Object)name);
            CraftTweakerAPI.logError("Duplicate ZenCode Name '%s' in classes '%s' and '%s'", name, otherCls, cls);
        }
        this.zenClasses.put((Object)name, cls);
        CraftTweakerAPI.logDebug("Registering '%s'", name);
    }

    private void addGlobal(Class<?> cls) {
        ZenCodeType.Name annotation = cls.getAnnotation(ZenCodeType.Name.class);
        this.zenGlobals.put((Object)annotation.value(), cls);
    }

    private void addExpansion(Class<?> cls, String expandedClassName) {
        if (!this.expansionsByExpandedName.containsKey(expandedClassName)) {
            this.expansionsByExpandedName.put(expandedClassName, new ArrayList());
        }
        this.expansionsByExpandedName.get(expandedClassName).add(cls);
    }

    private boolean hasGlobals(Class<?> cls) {
        return Stream.concat(Arrays.stream(cls.getFields()), Arrays.stream(cls.getMethods())).filter(member -> member.isAnnotationPresent(ZenCodeGlobals.Global.class)).filter(member -> Modifier.isPublic(((Member)((Object)member)).getModifiers())).anyMatch(member -> Modifier.isStatic(((Member)((Object)member)).getModifiers()));
    }

    public List<Class<?>> getClassesInPackage(String name) {
        return this.zenClasses.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(name)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public List<Class<?>> getGlobalsInPackage(String name) {
        return this.zenGlobals.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(name)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public Set<String> getRootPackages() {
        return this.zenClasses.keySet().stream().map(key -> key.split("\\.", 2)[0]).collect(Collectors.toSet());
    }

    public void addNativeType(Class<?> cls) {
        if (this.areModsMissing(cls.getAnnotation(ZenRegister.class))) {
            return;
        }
        if (cls.isAnnotationPresent(NativeTypeRegistration.class)) {
            this.addNativeAnnotation(cls);
        }
    }

    public void initNativeTypes() {
        for (CrTNativeTypeInfo nativeTypeInfo : this.nativeTypeRegistry.getNativeTypeInfos()) {
            String craftTweakerName = nativeTypeInfo.getCraftTweakerName();
            String vanillaClass = nativeTypeInfo.getVanillaClass().getCanonicalName();
            this.zenClasses.put((Object)craftTweakerName, nativeTypeInfo.getVanillaClass());
            CraftTweakerAPI.logDebug("Registering %s for native type '%s'", craftTweakerName, vanillaClass);
        }
    }

    public NativeTypeRegistry getNativeTypeRegistry() {
        return this.nativeTypeRegistry;
    }

    public boolean isBlacklisted(Class<?> cls) {
        return this.blacklistedClasses.contains(cls);
    }
}

